
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/freedom.zip" ),
}
local prefabs = {}


local start_inv = {
"freedom_exoskeleton",
"scroll",
}


local fn = function(inst)
	
	
	local function sanityfn(inst)
	local x,y,z = inst.Transform:GetWorldPosition()	
	local delta = 0
	local max_rad = 10
	local ents = TheSim:FindEntities(x,y,z, max_rad, {"duty"})
    for k,v in pairs(ents) do 
		if v.components.health and not v.components.health:IsDead() then
			local sz = -TUNING.SANITYAURA_MED
			local rad = 10
			sz = sz * ( math.min(max_rad, rad) / max_rad )
			local distsq = inst:GetDistanceSqToInst(v)
			delta = delta + sz/math.max(1, distsq)
    	end
    end
    
    return delta
end

inst.components.sanity.custom_rate_fn = sanityfn

local freedom_exoskeleton = Ingredient( "freedom_exoskeleton", 1)
freedom_exoskeleton.atlas = "images/inventoryimages/freedom_exoskeleton.xml"
local armor_device = Recipe("freedom_exoskeleton", { Ingredient("goldnugget", 28), freedom_exoskeleton }, RECIPETABS.REFINE, {REFINE=0})
armor_device.atlas = "images/inventoryimages/freedom_exoskeleton.xml"

--inst:AddComponent("petleash")
	--inst.components.petleash:SetMaxPets(4)
	inst.soundsname = "freedom"
	inst:AddTag("freedom")
	inst:AddTag("stalker")
	inst.MiniMapEntity:SetIcon( "freedom.tex" )

	
	inst.components.sanity.neg_aura_mult = 0.8
	
	
	-- Stats	
	inst.components.health:SetMaxHealth(200)
	inst.components.hunger:SetMax(200)
	inst.components.sanity:SetMax(200)
	inst.components.hunger.hungerrate = 1.1 * TUNING.WILSON_HUNGER_RATE
	
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.1)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.1)

end

return MakePlayerCharacter("freedom", prefabs, assets, fn, start_inv)
